##load libraries
library(DHARMa)
library(lme4)
library(car)
library(emmeans)
library(dplyr)

## read testing results
data= read.csv(file="RL - only complete.csv", header=TRUE)

## Set observation level random effect factor
data$obs <- 1:nrow(data)
data$obs <- as.factor(data$obs)

## make ID a factor
data$ID <- as.factor(data$ID)

## order factors
data$Test <- factor(data$Test, levels=c("Naive","Trained", "RL1", "RL2"))
data$Species <- factor(data$Species, levels=c("E", "M", "H"
                                              , "A", "Dd", "D"))

### initial preference---------------------------
model = glmer(cbind(nP, nY) ~ Species + (1|ID) , 
              data = subset(data, Test == "Naive"), 
              family = binomial, glmerControl(optimizer="bobyqa"))

model = glmer(cbind(nP, nY) ~ Heliconius + (1|Species)+ (1|ID) , 
                   data = subset(data, Test == "Naive"), 
              family = binomial, glmerControl(optimizer="bobyqa"))

simulationOutput <- simulateResiduals(fittedModel = model)
plot(simulationOutput)
testResiduals(simulationOutput)
Anova(model)
summary(model)

## Within-species analysis--------------------------------------------------------

## Create species subsets
DryasRL <- subset(data, Species == "D")
DryadulaRL <- subset(data, Species == "Dd")
EratoRL <- subset(data, Species == "E")
MelpomeneRL <- subset(data, Species == "M")
HecaleRL <- subset(data, Species == "H")
AgraulisRL <- subset(data, Species == "A")

##Within species model (replace dataset with chosen species)
model = glmer(cbind(TrainedCorrect, TrainedWrong) ~ Test + (1|ID) + (1|obs), 
              data = DryasRL, family = binomial, glmerControl(optimizer="bobyqa"))

simulationOutput <- simulateResiduals(fittedModel = model)
plot(simulationOutput)
testResiduals(simulationOutput)
Anova(model)

## post-hoc comparisons
means <- emmeans(model, ~Test)
summary(contrast(means, "pairwise")[c(1,4,6)], adjust = "sidak")


## Between species analysis---------------------------------------------------

## Does trained performance differ between Heliconius and non-Heliconius?
##First with sex included
model = glmer(cbind(TrainedCorrect, TrainedWrong) ~ Test*Heliconius*Sex  + (1|Species) + (1|ID) + (1|obs), 
              data = data,
              family = binomial, 
              glmerControl(optimizer="bobyqa")
)

simulationOutput <- simulateResiduals(fittedModel = model)
plot(simulationOutput)
testResiduals(simulationOutput)
testOutliers(simulationOutput, type = 'bootstrap')
summary(model)
Anova(model)

means <- emmeans(model, ~Test*Heliconius)
summary(contrast(means, "pairwise")[c(11,17,22)], adjust = "none")

### Sex factor removed
model = glmer(cbind(TrainedCorrect, TrainedWrong) ~ Test*Heliconius  + (1|Species) + (1|ID) + (1|obs), 
              data = data,
              family = binomial, 
              glmerControl(optimizer="bobyqa")
)

simulationOutput <- simulateResiduals(fittedModel = model)
plot(simulationOutput)
testResiduals(simulationOutput)
testOutliers(simulationOutput, type = 'bootstrap')
summary(model)
Anova(model)

means <- emmeans(model, ~Test*Heliconius)
summary(contrast(means, "pairwise")[c(11,17,22)], adjust = "Sidak")

##interspecific differences
model = glmer(cbind(TrainedCorrect, TrainedWrong) ~ Test*Species + (1|ID) + (1|obs), 
              data = data,
              family = binomial 
              ,glmerControl(optimizer="bobyqa")
)

simulationOutput <- simulateResiduals(fittedModel = model)
plot(simulationOutput)
testResiduals(simulationOutput)
summary(model)
Anova(model)

## post-hoc comparisons
means <- emmeans(model, ~Test*Species)
summary(contrast(means, "pairwise")[c(27,31,35,39,43,109,113,117,121,175,179,183,225,229,259)], adjust = "sidak")

summary(contrast(means, "pairwise")[c(49,53,57,61,65,127,131,135,139,189,193,197,235,239,265)], adjust = "sidak")

summary(contrast(means, "pairwise")[c(70,74,78,82,86,144,148,152,156,202,206,210,244,248,270)], adjust = "sidak")

## declines in accuracy with successive reversals?----------------------------
##Remove naive data
NoNaiveData = subset(data, Test != "Naive")
NoNaiveData = droplevels(NoNaiveData)

## Test for each species by changing subset
model = glmer(cbind(Correct, Wrong) ~ Test + (1|ID) + (1|obs), 
              data = subset(NoNaiveData, Species == "D"), family = binomial, 
              glmerControl(optimizer="bobyqa")
             )

simulationOutput <- simulateResiduals(fittedModel = model)
plot(simulationOutput)
testResiduals(simulationOutput)
summary(model)
Anova(model)

## post-hoc comparisons
means <- emmeans(model, ~Test)
summary(contrast(means, "pairwise"), adjust = "sidak")

## Do Heliconius exhibit greater change in accuracy between tests?
TrainedvsRL2 = subset(NoNaiveData, Test == "Trained" | Test == "RL2")
RL1vsRL2 = subset(NoNaiveData, Test == "RL1" | Test == "RL2")

model = glmer(cbind(Correct, Wrong) ~ Test*Heliconius + (1|Species) + (1|ID) + (1|obs), 
              data = TrainedvsRL2, family = binomial
              ,glmerControl(optimizer="bobyqa")
)

simulationOutput <- simulateResiduals(fittedModel = model)
plot(simulationOutput)
testResiduals(simulationOutput)
summary(model)
Anova(model)

## Individuals that learned - shift in preference Naive to Trained
NaivevsTrained = subset(data, Test == "Naive" | Test == "Trained")

Trained = subset(data, Test == "Trained")

singledata <- NaivevsTrained %>% group_by(ID) %>% filter(n() == 1)

NaivevsTrained <- NaivevsTrained[!(NaivevsTrained$ID %in% singledata$ID),]

IDs = as.data.frame(subset(NaivevsTrained, Test == "Trained")$ID)

Learningeffect <- data.frame(matrix(nrow = 0, ncol = 5))

for (i in 1:nrow(IDs)) {
    individual <- as.character(IDs[i,])
model = glm(cbind(Correct, Wrong) ~ Test, 
              data = subset(NaivevsTrained, ID == individual), family = binomial
           )

significance <- Anova(model)
significance <- cbind(individual, significance)
significance <- cbind(significance, subset(Trained, ID == individual)$propcorrect)
Learningeffect <- rbind(Learningeffect,significance)
}

colnames(Learningeffect) <- c("ID", "Chisq", "df", "P", "Trainedpropcorrect")

Learningeffect$P <- as.numeric(Learningeffect$P)

ShiftNaivetoTrained = subset(Learningeffect, P < 0.05)

NoShiftNaivetoTrained = subset(Learningeffect, P >= 0.05)

## Individuals that shift in preference Trained to RL1
RL1vsTrained = subset(data, Test == "RL1" | Test == "Trained")

RL1vsTrained <- RL1vsTrained[(RL1vsTrained$ID %in% ShiftNaivetoTrained$ID),]

singledata <- RL1vsTrained %>% group_by(ID) %>% filter(n() == 1)

RL1vsTrained <- RL1vsTrained[!(RL1vsTrained$ID %in% singledata$ID),]

IDs = as.data.frame(subset(RL1vsTrained, Test == "Trained")$ID)

RL1 <- subset(RL1vsTrained, Test == "RL1")

Learningeffect <- data.frame(matrix(nrow = 0, ncol = 5))


for (i in 1:nrow(IDs)) {
  individual <- as.character(IDs[i,])
  model = glm(cbind(nP, nY) ~ Test, 
              data = subset(RL1vsTrained, ID == individual), family = binomial
  )
  
  significance <- Anova(model)
  significance <- cbind(individual, significance)
  significance <- cbind(significance, subset(RL1, ID == individual)$propcorrect)
  Learningeffect <- rbind(Learningeffect,significance)
}

colnames(Learningeffect) <- c("ID", "Chisq", "df", "P", "Trainedpropcorrect")

Learningeffect$P <- as.numeric(Learningeffect$P)

NoshiftTrainedtoRL1 = subset(Learningeffect, P > 0.05)

ShiftTrainedtoRL1 = subset(Learningeffect, P < 0.05)

## Individuals that shift in preference RL1 to RL2
RL1vsRL2 = subset(data, Test == "RL1" | Test == "RL2")

RL1vsRL2 <- RL1vsRL2[(RL1vsRL2$ID %in% ShiftTrainedtoRL1$ID),]

singledata <- RL1vsRL2 %>% group_by(ID) %>% filter(n() == 1)

RL1vsRL2 <- RL1vsRL2[!(RL1vsRL2$ID %in% singledata$ID),]

IDs = as.data.frame(subset(RL1vsRL2, Test == "RL1")$ID)

RL2 <- subset(RL1vsRL2, Test == "RL2")

Learningeffect <- data.frame(matrix(nrow = 0, ncol = 5))

for (i in 1:nrow(IDs)) {
  individual <- as.character(IDs[i,])
  model = glm(cbind(nP, nY) ~ Test, 
              data = subset(RL1vsRL2, ID == individual), family = binomial
  )
  
  significance <- Anova(model)
  significance <- cbind(individual, significance)
  significance <- cbind(significance, subset(RL2, ID == individual)$propcorrect)
  Learningeffect <- rbind(Learningeffect,significance)
}

Learningeffect$P <- as.numeric(Learningeffect$P)

colnames(Learningeffect) <- c("ID", "Chisq", "df", "P", "propcorrect")

NoshiftRL1toRL2 = subset(Learningeffect, P > 0.05)


## Do species differ in number of successful individuals in trials?
successes <- read.csv("successful trials.csv")

model = glm(cbind(successes, failures) ~ species, 
            data = subset(successes, trial == "RL1vsRL2"), family = binomial
)

simulationOutput <- simulateResiduals(fittedModel = model)
plot(simulationOutput)
testResiduals(simulationOutput)
summary(model)
Anova(model)
